VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "clsQueue"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = False
Option Explicit

Private Queue()         As QE
Private Type QE
    Message             As String
    Priority            As Byte
End Type

Public Last_Msg_Sent    As Long
Private Consec_Msg_Sent As Integer

Private Sub Class_Initialize()
    ReDim Queue(0)
End Sub

Private Sub Class_Terminate()
    ReDim Queue(0)
End Sub

Public Function PeekQueue(ByVal Index As Integer)
     If Index - 1 > UBound(Queue) Then Exit Function
     PeekQueue = Queue(Index).Message
End Function

Public Sub ResetQueue()
     ReDim Queue(0)
End Sub

Public Sub AddQueue(ByVal Message As String, ByVal Priority As Byte)
     Queue(UBound(Queue)).Message = Message
     Queue(UBound(Queue)).Priority = Priority
     ReDim Preserve Queue(UBound(Queue) + 1)
End Sub

Public Sub InsertQueue(ByVal Index As Integer, ByVal Message As String, ByVal Priority As Byte)
     If Index - 1 > UBound(Queue) Then Exit Sub
     Dim i As Integer, TempBuf As String
     For i = UBound(Queue) - 1 To Index Step -1
          Queue(i + 1) = Queue(i)
     Next i
     Queue(Index).Message = Message
     Queue(Index).Priority = Priority
     
     ReDim Preserve Queue(UBound(Queue) + 1)
End Sub

Public Sub DeleteQueue(ByVal Index As Integer)
     If Index - 1 > UBound(Queue) Then Exit Sub
     Dim i As Integer
     For i = Index To UBound(Queue) - 1
          Queue(i) = Queue(i + 1)
     Next i
     ReDim Preserve Queue(UBound(Queue) - 1)
End Sub

Private Sub StepQueue()
     If UBound(Queue) = 0 Then Exit Sub
     Dim i As Integer
     For i = 0 To UBound(Queue) - 1
          Queue(i) = Queue(i + 1)
     Next i
     ReDim Preserve Queue(UBound(Queue) - 1)
End Sub

Public Function GetQueue() As String
    Dim i As Integer
    Dim tmpPriority As Byte
    Dim Index As Integer
    Index = 0
    
    If Options.Prioritize_Queue = True Then
        tmpPriority = 5
        For i = 0 To UBound(Queue) - 1
            If Queue(i).Priority < tmpPriority And tmpPriority <> 0 Then
                Index = i
                'Priority of 1 means it's the most important:
                If Queue(Index).Priority = 1 Then Exit For
                tmpPriority = Queue(i).Priority
            End If
        Next i
    End If
    
    If Queue(Index).Message <> vbNullString Then
        If RequiredDelay(Len(Queue(Index))) = 0 Then
            GetQueue = Queue(Index).Message
            Call DeleteQueue(Index) 'Delete Queue Message
            If GetTickCount - Last_Msg_Sent > 20000 Then Consec_Msg_Sent = 0
            If GetTickCount - Last_Msg_Sent > 12000 Then
                Last_Msg_Sent = GetTickCount()
                Consec_Msg_Sent = Consec_Msg_Sent - 2
                If Consec_Msg_Sent < 0 Then Consec_Msg_Sent = 0
            Else
                Consec_Msg_Sent = Consec_Msg_Sent + 1
                'If Consec_Msg_Sent = 3 Then SentBytes = SentBytes + 20
                If Consec_Msg_Sent > 6 Then SentBytes = SentBytes + 1000
                If Consec_Msg_Sent > 5 Then LastTick = LastTick + 200: SentBytes = SentBytes + 100
                If Consec_Msg_Sent > 4 Then SentBytes = SentBytes + 600
                If Consec_Msg_Sent > 3 Then LastTick = LastTick + 3000: SentBytes = SentBytes + 100
            End If
        Else
            GetQueue = vbNullString
            KillTimer frmMain.hwnd, 2
            SetTimer frmMain.hwnd, 2, 100, AddressOf TMR_QUEUE
        End If
    End If
End Function

Public Function QueueCount() As Integer
     QueueCount = UBound(Queue)
End Function

Public Sub addBytes(ByVal bytes As Long)
'Adds Bytes to The Outgoing FloodProtection Vars, for extra flood protection
' (i.e., after connect, etc)
    SentBytes = SentBytes + bytes
    If LastTick = 0 Then LastTick = GetTickCount
End Sub

Public Function Kill_Ban_Queue() As Integer
    Dim i As Integer
    For i = QueueCount To 0 Step -1
        If Left$(LCase$(Queue(i).Message), 5) = "/ban " Then
            Call DeleteQueue(i)
            Kill_Ban_Queue = Kill_Ban_Queue + 1
        End If
    Next i
End Function
